#!/bin/bash
set -e # exit on error
DATASET="unk_vqa_public_val_k_minus_llava_remove_ans_type2_no_prompt"
MODEL_PATH=$1
if [ -z "$2" ]; then
    overwrite=False
else
    overwrite=$2
fi

bash scripts/v1_5/eval/unk_vqa_public_val.sh $MODEL_PATH $overwrite

pred_data=$(python llava/eval/utils.py check_output_file_exists --output_file ${MODEL_PATH}/${DATASET}/merge.jsonl)
echo "pred_data: ${pred_data}"


question_file=<DATA_FOLDER>/UNK-VQA/val_k_minus_llava_remove_ans_type2.llava_eval.jsonl
image_folder="<DATA_FOLDER>/UNK-VQA"

MODEL_PATH_LOWER=$(echo "$MODEL_PATH" | tr '[:upper:]' '[:lower:]')
if [[ $MODEL_PATH_LOWER == *"qwen-vl"* ]]; then
    echo "qwen-vl in model path"

else
    echo "skip"
fi


python llava/eval/lave_metric.py  run_lave_metric \
      --gt_data ${question_file} \
      --model_id models/Mistral/Mistral-7B-Instruct-v0.2 \
      --pred_data ${pred_data}  